<!-- Search Bar -->
<form action="" method="GET" class="mb-4">
    <div class="input-group">
        <input type="text" name="search" class="form-control" 
               placeholder="Search cars..." 
               value="<?php echo htmlspecialchars($search ?? ''); ?>">
        <button class="btn btn-primary" type="submit">
            <i class="fas fa-search"></i>
        </button>
    </div>
</form>

<!-- Brands Filter -->
<div class="filter-section mb-4">
    <h5 class="mb-3">Brands</h5>
    <div class="brands-list">
    <a href="cars.php" 
               class="d-flex justify-content-between align-items-center py-2 text-decoration-none <?php echo $brand_id == $brand['id'] ? 'active' : ''; ?>">
                <span>All Brands</span>
                
            </a>
        <?php foreach ($brands as $brand): ?>
            <a href="?brand=<?php echo $brand['id']; ?>" 
               class="d-flex justify-content-between align-items-center py-2 text-decoration-none <?php echo $brand_id == $brand['id'] ? 'active' : ''; ?>">
                <span><?php echo htmlspecialchars($brand['name']); ?></span>
                <span class="badge bg-secondary rounded-pill">
                    <?php echo $brand['car_count']; ?>
                </span>
            </a>
        <?php endforeach; ?>
    </div>
</div>

<!-- Body Types Filter -->
<div class="filter-section mb-4">
    <h5 class="mb-3">Body Types</h5>
    <div class="body-types-list">
        <?php
        $body_types = [
            ['name' => 'SUV', 'icon' => 'fa-car-side'],
            ['name' => 'Sedan', 'icon' => 'fa-car'],
            ['name' => 'Hatchback', 'icon' => 'fa-car-side'],
            ['name' => 'Coupe', 'icon' => 'fa-car'],
            ['name' => 'Convertible', 'icon' => 'fa-car-side'],
            ['name' => 'Wagon', 'icon' => 'fa-car'],
            ['name' => 'Van', 'icon' => 'fa-shuttle-van'],
            ['name' => 'Truck', 'icon' => 'fa-truck']
        ];
        
        // Get body type counts
        $body_type_counts = [];
        $count_query = "SELECT body_type, COUNT(*) as count FROM cars WHERE status = 'Available' GROUP BY body_type";
        $counts = $db->query($count_query)->fetchAll(PDO::FETCH_KEY_PAIR);
        
        foreach ($body_types as $type): ?>
            <a href="?body_type=<?php echo $type['name']; ?>" 
               class="d-flex justify-content-between align-items-center py-2 text-decoration-none">
                <div>
                    <i class="fas <?php echo $type['icon']; ?> me-2"></i>
                    <span><?php echo $type['name']; ?></span>
                </div>
                <span class="badge bg-secondary rounded-pill">
                    <?php echo $counts[$type['name']] ?? 0; ?>
                </span>
            </a>
        <?php endforeach; ?>
    </div>
</div>

<!-- Fuel Types Filter -->
<div class="filter-section mb-4">
    <h5 class="mb-3">Fuel Type</h5>
    <div class="fuel-types-list">
        <?php
        $fuel_types = [
            'Petrol' => 'fa-gas-pump',
            'Diesel' => 'fa-gas-pump',
            'Electric' => 'fa-bolt',
            'Hybrid' => 'fa-leaf'
        ];
        foreach ($fuel_types as $type => $icon): ?>
            <a href="?fuel_type=<?php echo $type; ?>" 
               class="d-flex align-items-center py-2 text-decoration-none">
                <i class="fas <?php echo $icon; ?> me-2"></i>
                <span><?php echo $type; ?></span>
            </a>
        <?php endforeach; ?>
    </div>
</div>

<!-- Price Range Filter -->
<div class="filter-section mb-4">
    <h5 class="mb-3">Price Range</h5>
    <div class="price-ranges-list">
        <?php foreach ($price_ranges as $range): ?>
            <a href="?min_price=<?php echo $range['min']; ?>&max_price=<?php echo $range['max']; ?>" 
               class="d-flex justify-content-between align-items-center py-2 text-decoration-none">
                <span><?php echo $range['label']; ?></span>
            </a>
        <?php endforeach; ?>
    </div>
</div> 